#pragma once

#include <library/cpp/lua/eval.h>
#include <util/generic/map.h>
#include <util/generic/string.h>
#include <search/config/preprocessor/preprocessor.h>

namespace NDrive::NPumpkin {
    // Substitutes known variables of kind ${var}.
    class TLuaJsonTextPatcher {
    public:
        TLuaJsonTextPatcher& AddVariable(const TString& key, const TString& value);
        void Patch(IInputStream& in, IOutputStream& out);
        TString Patch(const TString& text);

    private:
        TConfigPreprocessor Preprocessor;
    };
}
