#include "permissions.h"

#include <rtline/library/json/builder.h>
#include <rtline/library/json/parse.h>

template<>
NJson::TJsonValue NJson::ToJson(const NDrive::NPumpkin::TUserPermissions& userPermissions) {
    return NJson::TMapBuilder
        ("allowed_commands", ToJson(userPermissions.AllowedCommands))
        ("user_login", userPermissions.UserLogin)
    ;
}

template<>
bool NJson::TryFromJson(const NJson::TJsonValue& jsonValue, NDrive::NPumpkin::TUserPermissions& userPermissions) {
    return NJson::ParseField(jsonValue["allowed_commands"], userPermissions.AllowedCommands)
        && NJson::ParseField(jsonValue["user_login"], userPermissions.UserLogin)
    ;
}

namespace NDrive::NPumpkin {

    TUsersPermissionsStorage::TUsersPermissionsStorage(TVector<TUserPermissions>&& userPermissions) {
        for (auto&& permissions : userPermissions) {
            Permissions[permissions.UserLogin] = std::move(permissions);
        }
    }

    const TUserPermissions* TUsersPermissionsStorage::GetUserPermissions(TStringBuf userLogin) const {
        auto it = Permissions.find(userLogin);
        return it != Permissions.end()
            ? &it->second
            : nullptr;
    }
}
