#pragma once

#include <util/generic/map.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NDrive::NPumpkin {
    struct TUserPermissions {
        TVector<TString> AllowedCommands;
        TString UserLogin;
    };

    class TUsersPermissionsStorage {
    public:
        using TUserLogin = TString;

    public:
        TUsersPermissionsStorage(TVector<TUserPermissions>&& userPermissions);
        const TUserPermissions* GetUserPermissions(TStringBuf login) const;

    private:
        TMap<TUserLogin, TUserPermissions> Permissions;
    };
}
