#pragma once

#include "auth.h"
#include "cars_storage.h"
#include "config.h"
#include "permissions.h"
#include "sensors_storage.h"

#include <drive/library/cpp/searchserver/server.h>
#include <drive/telematics/api/sensor/interface.h>
#include <drive/telematics/api/server/client.h>

#include <kernel/daemon/signal_handler.h>

#include <library/cpp/mediator/messenger.h>

#include <rtline/util/algorithm/ptr.h>

#include <util/system/mutex.h>


namespace NDrive {
    class TPumpkin
        : public TSearchServerBase
    {
    public:
        TPumpkin();
        void Run();
        void Wait();
        void Stop() override;
        const NDrive::NPumpkin::IAuthManager& GetAuthManager() const;
        const NDrive::TTelematicsClient& GetTelematicsClient() const;
        const NDrive::NPumpkin::TSimpleCarsDataStorage& GetSimpleCarsDataStorage() const;
        const ISensorApi& GetSensorAPI() const;
        const NDrive::NPumpkin::TSensorsStorage& GetSensorsStorage() const;
        const NDrive::NPumpkin::TUsersPermissionsStorage& GetUsersPermissionsStorage() const;
        static void SetConfig(const NDrive::NPumpkin::TConfig& config);

        ui32 GetPort() const;
        TDuration GetSensorsAPIQueryTimeout() const;

    private:
        static void AbortOnException();
        static void AbortOnSignal(int signal);
        static void ReopenLogStatic(int);
        static void StopServerStatic(int signal);

        void ReopenLog(int);
        void StopServer(int signal);
        void HandleSignals();
        virtual TClientRequest* CreateClient() override;
        void InitSimpleCarsDataStorage(const NDrive::NPumpkin::NProto::TSimpleCarsDataStorageConfig& config);
        void InitRTLineAPIs(const ::google::protobuf::RepeatedPtrField< ::NDrive::NPumpkin::NProto::TRTLineAPIConfig >& protoConfigs);
        void InitSensorAPI();
        void InitSensorsStorage(TAtomicSharedPtr<ISensorApi> sensorAPI);
        void InitUsersPermissionsStorage(const NDrive::NPumpkin::NProto::TUsersPermissionsStorageConfig& config);

    private:
        static NDrive::NPumpkin::TConfig Config; // TODO: remove static somehow? Now need static for Singleton

    private:
        THolder<NUtil::TSigHandlerThread> SigHandlerThread;
        THolder<NDrive::NPumpkin::IAuthManager> AuthManager;
        THolder<NDrive::NPumpkin::TSimpleCarsDataStorage> SimpleCarsDataStorage;
        THolder<NDrive::TTelematicsClient> TelematicsClient;
        TMap<TString, TRTLineAPI> RTLineAPIs;
        TAtomicSharedPtr<ISensorApi> SensorAPI;
        THolder<NDrive::NPumpkin::TSensorsStorage> SensorsStorage;
        THolder<NDrive::NPumpkin::TUsersPermissionsStorage> UsersPermissionsStorage;
        TMutex Mutex;
        bool Stopped = false;
    };
}
