#pragma once

#include <drive/backend/auth/common/auth.h>
#include <drive/library/cpp/searchserver/replier.h>

#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/json/writer/json_value.h>

namespace NDrive {
    class TPumpkin;
}

namespace NDrive::NPumpkin {
    struct TUserPermissions;
}

namespace NDrive::NPumpkin {
    class TReplier : public IHttpReplier {
    public:
        TReplier(const NDrive::TPumpkin& pumpkin, IReplyContext::TPtr context);


    private:
        virtual void DoSearchAndReply() override;
        virtual IThreadPool* DoSelectHandler() override;
        virtual void OnRequestExpired() override;
        virtual TDuration GetDefaultTimeout() const override;
        IAuthInfo::TPtr GetAuthInfo() const;
        void CarControl(const NJson::TJsonValue& requestData, const NDrive::NPumpkin::TUserPermissions& permissions) const;
        void CarSearch(const NJson::TJsonValue& requestData) const;
        void CarInfo(const NJson::TJsonValue& requestData, const TCgiParameters& cgi) const;
        void CarList(const NJson::TJsonValue& requestData, const TCgiParameters& cgi) const;
        void AllowedCommands(const NDrive::NPumpkin::TUserPermissions& permissions) const;

        NJson::TJsonValue GetPost() const;
        void SendReply(NJson::TJsonValue&& reply, ui32 code = HTTP_OK) const;

    private:
        const NDrive::TPumpkin& Pumpkin;
        const IReplyContext::TPtr Context;
    };
}
