#pragma once

#include <drive/library/cpp/threading/future.h>
#include <drive/telematics/api/sensor/interface.h>

#include <rtline/util/auto_actualization.h>

#include <util/system/rwlock.h>

namespace NDrive::NPumpkin {
    class TSensorsStorage final : public IAutoActualization {
    public:
        TSensorsStorage(TAtomicSharedPtr<NDrive::ISensorApi> sensorAPI, TDuration updateInterval);
        ~TSensorsStorage();
        TMap<TString, TMap<TString, NDrive::TLocation>> GetLocations(const TVector<TString>& imeis) const;

    private:
        bool Refresh() override;

    private:
        static TVector<TString> LocationsNames;

    private:
        TAtomicSharedPtr<NDrive::ISensorApi> SensorAPI;
        TMap<TString, NDrive::ISensorApi::TLocations> Locations;
        mutable TRWMutex Mutex;
    };
}
