#include "tvm.h"

namespace NDrive::NPumpkin {
    TAtomicSharedPtr<NTvmAuth::TTvmClient> BuildTvmClient(const NDrive::NPumpkin::NProto::TTvmConfig& config) {
        NTvmAuth::NTvmApi::TClientSettings settings;

        settings.SetSelfTvmId(config.GetSelfClientId());
        settings.EnableServiceTicketChecking();
        settings.EnableUserTicketChecking(NTvmAuth::EBlackboxEnv::Prod);
        if (const auto& cache = config.GetCache()) {
            settings.SetDiskCacheDir(cache);
        }
        if (const auto& secret = config.GetSecret()) {
            NTvmAuth::NTvmApi::TClientSettings::TDstVector destinations;
            for (const auto& destinationId : config.GetDestinationClientIds()) {
                destinations.emplace_back(destinationId);
            }
            settings.EnableServiceTicketsFetchOptions(secret, std::move(destinations));
        }

        return MakeAtomicShared<NTvmAuth::TTvmClient>(settings, CreateGlobalTvmLogger());
    }
}
