#include <drive/pumpkin/library/json_text_patcher.h>
#include <rtline/library/json/builder.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(JsonTextPatcher) {
    Y_UNIT_TEST(TestPatcher) {
        TString text = R"(
            {
                "int":${INT1},
                "str":"${STR1}",
                "array":[
                    ${INT2},${INT3},${STR2}
                ]
            })";

        NDrive::NPumpkin::TLuaJsonTextPatcher patcher;
        patcher.AddVariable("INT1", "1")
                .AddVariable("STR1", "string")
                .AddVariable("INT2", "2")
                .AddVariable("INT3", "3")
                .AddVariable("STR2", "another_string");
        auto patchedText = patcher.Patch(text);
        NJson::TJsonValue jsonValue;
        NJson::ReadJsonFastTree(patchedText, &jsonValue, /*throwOnError=*/ true);
        NJson::TJsonValue expected = NJson::TMapBuilder
            ("int", 1)
            ("str", "string")
            ("array", NJson::TArrayBuilder(2)(3)("another_string"));
        UNIT_ASSERT_VALUES_EQUAL(expected.GetStringRobust(), jsonValue.GetStringRobust());
    }
}
