#include "helper.h"

#include <library/cpp/http/simple/http_client.h>

namespace NDrive {
    void TPumpkinBuilder::Run(const NDrive::NPumpkin::TConfig& config) {
        NDrive::TPumpkin::SetConfig(config);
        Singleton<NDrive::TPumpkin>()->Run();
    }

    void TPumpkinBuilder::Stop() {
        Singleton<NDrive::TPumpkin>()->Stop();
    }

    std::pair<ui32, NJson::TJsonValue> TPumpkinBuilder::CarControl(const NJson::TJsonValue& body) {
        return SendQuery("/api/staff/car/control", body);
    }

    std::pair<ui32, NJson::TJsonValue> TPumpkinBuilder::CarSearch(const NJson::TJsonValue& body) {
        return SendQuery("/api/staff/car/search", body);
    }

    std::pair<ui32, NJson::TJsonValue> TPumpkinBuilder::CarInfo(const NJson::TJsonValue& body) {
        return SendQuery("/api/staff/car/info", body);
    }

    std::pair<ui32, NJson::TJsonValue> TPumpkinBuilder::CarList(const NJson::TJsonValue& body) {
        return SendQuery("/api/staff/car/list", body);
    }

    std::pair<ui32, NJson::TJsonValue> TPumpkinBuilder::SendQuery(const TString& relativeUrl, const NJson::TJsonValue& body) {
        TStringStream ss;
        ui32 code;
        code = TKeepAliveHttpClient("::1", Singleton<NDrive::TPumpkin>()->GetPort()).DoPost(relativeUrl, ToString(body), &ss);
        NJson::TJsonValue res;
        NJson::ReadJsonFastTree(ss.Str(), &res, true);
        return std::make_pair(code, std::move(res));
    }
}
