#pragma once

#include <drive/pumpkin/library/config.h>
#include <drive/pumpkin/library/pumpkin.h>

namespace NDrive {
    class TPumpkinBuilder {
    public:
        void Run(const NDrive::NPumpkin::TConfig& config);
        void Stop();

        std::pair<ui32, NJson::TJsonValue> CarControl(const NJson::TJsonValue& body);
        std::pair<ui32, NJson::TJsonValue> CarSearch(const NJson::TJsonValue& body);
        std::pair<ui32, NJson::TJsonValue> CarInfo(const NJson::TJsonValue& body);
        std::pair<ui32, NJson::TJsonValue> CarList(const NJson::TJsonValue& body);

    private:
        std::pair<ui32, NJson::TJsonValue> SendQuery(const TString& relativeUrl, const NJson::TJsonValue& body);
    };
}
