# -*- coding: utf-8 -*-                                                                                                                                                     [25/9471]
import base64                                                                                              
import os                           
from Crypto.Cipher import AES
                           
CHUNK_SIZE = 1024 * AES.block_size
                                                                         
IV_LENGTH=96                  
KEY_LENGTH=32                              
                                
def encrypt_string(in_str, key, iv='', associated_data=''):
    """
    :type in_str: str      
    :type key: str         
    :type iv: str         
    :rtype str
    """
    if len(iv) != IV_LENGTH:
        iv = os.urandom(IV_LENGTH)                                
    encryptor = AES.new(key=key.encode('utf-8'), mode=AES.MODE_GCM, nonce=iv)
    encryptor.update(associated_data)
    pkcs7 = PKCS7Encoder().encode(in_str)         
    encryped = encryptor.encrypt(pkcs7)          
    tag = encryptor.digest()           
                       
    return base64.b64encode(encryped), base64.b64encode(tag), base64.b64encode(iv)
                          

def decrypt_string(in_str, key, iv, tag, associated_data=''):
    """
    :type in_str: str
    :type key: str
    :type iv: str
    :rtype str
    """
    decryptor = AES.new(key=key, mode=AES.MODE_GCM, nonce=iv)
    decryptor.update(associated_data)
    base = base64.b64decode(in_str)
    decrypted = decryptor.decrypt(base)
    decryptor.verify(base64.b64decode(tag))
    return PKCS7Encoder().decode(decrypted)


class PKCS7Encoder:
    """
    Technique for padding a string as defined in RFC 2315, section 10.3,
    note #2
    """
    class InvalidBlockSizeError(Exception):
        """Raised for invalid block sizes"""
        pass

    def __init__(self, block_size=16):
        if block_size < 2 or block_size > 255:
            raise PKCS7Encoder.InvalidBlockSizeError('The block size must be between 2 and 255, inclusive')
        self.block_size = block_size

    def encode(self, text):
        text_length = len(text)
        amount_to_pad = self.block_size - (text_length % self.block_size)
        if amount_to_pad == 0:
            amount_to_pad = self.block_size
        pad = chr(amount_to_pad)
        return text + pad.encode('utf-8') * amount_to_pad

    def decode(self, text):
        pad = ord(text[-1])
        return text[:-pad]


if __name__ == '__main__':
    with open('/home/ia3leonid/baskets/fre/156.jpg', 'r') as file:
        orig = file.read()
    key = os.urandom(KEY_LENGTH)
    encrypted, tag, iv = encrypt_string(orig, key)
    img = decrypt_string(encrypted, key, iv, tag)
    with open('test.jpg', 'w') as file:
        file.write(img)
