import django
django.setup()

import json

import requests

import yt.wrapper as yt

from cars.core.mds.wrapper import MDSDocumentsWrapper
from cars.users.models import User, UserDocumentPhoto

from crypto import encrypt_string


TOTAL_PHOTOS = 250000
BUFFER_SIZE = 1000

CLIENT = MDSDocumentsWrapper.from_settings()
TOKEN = open('oauth_token.txt').read().strip()
KEY = open('docs_key.txt').read().strip()

def get_user_document_photo(user_id):
    photo_model = UserDocumentPhoto.objects.filter(user_id=user_id).order_by('-submitted_at').first()
    if photo_model is None:
        return None
    photo = CLIENT.get_user_document_photo(photo_model)
    return photo


def get_document_photo_text(user_id):
    try:
        r = requests.get(
            'https://carsharing.yandex-team.ru/api/admin/v1/users/{}/'.format(user_id),
            headers={
                'Authorization': 'OAuth {}'.format(TOKEN)
            },
            timeout=10
        )
        r.raise_for_status()
        data = r.json()
        if 'passport' not in data:
            print('passport not in data')
            return None
        return json.dumps(data['passport'], ensure_ascii=False).encode('utf-8')
    except Exception as e:
        print('could not get textdata for', user_id, str(e))


if __name__ == '__main__':
    active_users = User.objects.filter(status='active').only('id', 'status')
    user_ids = []
    for user in active_users:
        user_ids.append(str(user.id))
    user_ids = user_ids[:TOTAL_PHOTOS]

    buffer = []
    batch_no = 0
    for user_id in user_ids:
        try:
            photo_value = get_user_document_photo(user_id)
            photo_text = get_document_photo_text(user_id)
        except Exception as e:
            print('exception for', user_id, str(e))
            continue
        
        if not photo_value or not photo_text:
            continue

        photo_encrypted, photo_tag, photo_iv = encrypt_string(photo_value, KEY)
        text_encrypted, text_tag, text_iv = encrypt_string(photo_text, KEY)

        user_dict = {
            'photo_encrypted': photo_encrypted.decode('utf-8'),
            'photo_tag': photo_tag.decode('utf-8'),
            'photo_iv': photo_iv.decode('utf-8'),
            'text_encrypted': photo_encrypted.decode('utf-8'),
            'text_tag': photo_tag.decode('utf-8'),
            'text_iv': photo_iv.decode('utf-8'),
            'internal_id': user_id
        }

        buffer.append(user_dict)
        if len(buffer) == BUFFER_SIZE:
            batch_no += 1
            yt.write_table('//home/carsharing/production/export/documents/batch_' + str(batch_no), buffer, format='json')
            buffer = []

    if buffer:
        yt.write_table('//home/carsharing/production/export/documents/batch_' + str(batch_no + 1), buffer, format='json')
