from django.db import models

from ..permissions import AdminPermissionCode


class AdminPermissions(models.Model):

    class Meta:
        managed = False
        permissions = [
            (code.value, name)
            for code, name in [
                (AdminPermissionCode.ACCESS, 'Access admin site'),
                (AdminPermissionCode.OPERATE_BONUS_ACCOUNTS, 'Perform actions on bonus accounts'),
                (AdminPermissionCode.OPERATE_CARS, 'Perform actions on car'),
                (AdminPermissionCode.OPERATE_TARIFFS, 'Perform actions on tariffs'),
                (AdminPermissionCode.OPERATE_USERS, 'Perform actions on users'),
                (AdminPermissionCode.OPERATE_PUSH_PRESETS, 'Change push presets'),
                (AdminPermissionCode.REFUND_ORDERS, 'Refund order payments'),
                (AdminPermissionCode.REGISTER_CALLS, 'Register telephony calls'),
                (AdminPermissionCode.SEND_PRESET_PUSH, 'Send preset pushes'),
                (AdminPermissionCode.SEND_ARBITARY_PUSH, 'Send arbitary pushes'),
                (AdminPermissionCode.VIEW_ALL_CARS, 'View and search all cars'),
                (AdminPermissionCode.VIEW_ALL_ORDERS, 'View and search all orders'),
                (AdminPermissionCode.VIEW_ALL_USERS, 'View and search all users'),
                (AdminPermissionCode.VIEW_BONUS_ACCOUNTS, 'View bonus accounts'),
                (AdminPermissionCode.VIEW_CAR, 'View car card'),
                (AdminPermissionCode.VIEW_USER, 'View user card'),
                (AdminPermissionCode.VIEW_USER_DOCUMENT_PHOTOS, 'View user document photos'),
                (AdminPermissionCode.VIEW_USER_DOCUMENT_VIDEOS, 'View user document videos'),
            ]
        ]
