import uuid

from django.db import models

from cars.users.models import User


class PushPreset(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)
    message = models.TextField()

    class Meta:
        db_table = 'push_preset'


class PushMessagesSet(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)
    message = models.TextField()

    class Meta:
        db_table = 'push_messages_set'


class PushMessagesHistory(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    time_id = models.DateTimeField()

    uid = models.BigIntegerField()  # user uid

    message = models.ForeignKey(
        PushMessagesSet,
        on_delete=models.CASCADE,
    )

    codes = models.TextField()  # comma-separated response codes

    sender = models.ForeignKey(
        User,
        on_delete=models.SET_NULL,
        null=True,
    )

    @property
    def is_successfully_delivered(self):
        return '200' in self.codes

    class Meta:
        db_table = 'push_messages_history'

        indexes = [
            models.Index(
                fields=['time_id'],
                name='push_messages_history_time_id_idx',
            ),
            models.Index(
                fields=['uid'],
                name='push_messages_history_uid_idx',
            ),
        ]
