import enum
import os

from rest_framework.permissions import BasePermission


class AdminPermissionCode(enum.Enum):
    ACCESS = 'access'
    OPERATE_BONUS_ACCOUNTS = 'operate_bonus_accounts'
    OPERATE_CARS = 'operate_cars'
    OPERATE_TARIFFS = 'operate_tariffs'
    OPERATE_USERS = 'operate_users'
    OPERATE_PUSH_PRESETS = 'operate_push_presets'
    REFUND_ORDERS = 'refund_orders'
    REGISTER_CALLS = 'register_calls'
    SEND_PRESET_PUSH = 'send_preset_push'
    SEND_ARBITARY_PUSH = 'send_arbitary_push'
    VIEW_ALL_CARS = 'view_all_cars'
    VIEW_ALL_ORDERS = 'view_all_orders'
    VIEW_ALL_USERS = 'view_all_users'
    VIEW_BONUS_ACCOUNTS = 'view_bonus_accounts'
    VIEW_CAR = 'view_car'
    VIEW_USER = 'view_user'
    VIEW_USER_DOCUMENT_PHOTOS = 'view_user_document_photos'
    VIEW_USER_DOCUMENT_VIDEOS = 'view_user_document_videos'

    @classmethod
    def get_full_code(cls, code):
        return 'cars_admin.{}'.format(code.value)


class AdminPermissionFactory:

    @classmethod
    def build(cls, code):

        class AdminPermission(BasePermission):

            full_code = AdminPermissionCode.get_full_code(code)

            def has_permission(self, request, view):
                if os.environ.get('CARSHARING_FEATURE_ADMIN_PERMISSIONS') == '1':
                    has_perm = request.user.has_perm(self.full_code)
                else:
                    has_perm = True
                return has_perm

        return AdminPermission
