from rest_framework.serializers import ChoiceField, CharField, ModelSerializer

from cars.bans.models.ban import Ban
from cars.django.serializers import BaseSerializer, TimestampField
from .user_simple import SimpleUserSerializer


class UserBlockArgumentsSerializer(BaseSerializer):
    comment = CharField(required=False)
    reason = ChoiceField(choices=[x.value for x in Ban.Reason], required=True)

    def validate_reason(self, value):
        return Ban.Reason(value)


class BanSerializer(ModelSerializer):
    started_at = TimestampField()
    finished_at = TimestampField()
    started_by = SimpleUserSerializer()
    finished_by = SimpleUserSerializer()

    class Meta:
        model = Ban
        fields = [
            'id',
            'started_at',
            'finished_at',
            'started_by',
            'finished_by',
            'reason',
            'comment',
        ]
