from rest_framework.serializers import ModelSerializer, SerializerMethodField

from cars.carsharing.models.car_assembly import CarAssemblyPhoto
from cars.carsharing.models.car_assembly_stage import CarAssemblyStage
from cars.django.serializers import TimestampField
from .carsharing_simple import SimpleCarSerializer
from .user_simple import SimpleUserSerializer


class CarAssemblyPhotoSerializer(ModelSerializer):

    car = SimpleCarSerializer()
    added_at = TimestampField()
    added_by = SimpleUserSerializer()

    class Meta:
        model = CarAssemblyPhoto
        fields = '__all__'


class CarAssemblyStageSerializer(ModelSerializer):

    photos = SerializerMethodField()

    class Meta:
        model = CarAssemblyStage
        fields = [
            'id',
            'name',
            'photos',
        ]

    def get_photos(self, obj):
        all_photos = self.context['photos_serialized']
        return [
            x for x in all_photos if x['stage'] == obj.id
        ]
