from rest_framework.serializers import ModelSerializer

from cars.carsharing.models import CarsharingTagPhoto
from cars.django.serializers import TimestampField
from .carsharing_simple import SimpleCarSerializer
from .user_simple import SimpleUserSerializer


class CarsharingTagPhotoSerializer(ModelSerializer):

    submitted_at = TimestampField()
    submitted_by = SimpleUserSerializer()
    car = SimpleCarSerializer()

    class Meta:
        model = CarsharingTagPhoto
        fields = '__all__'
