from rest_framework.serializers import DateTimeField, ModelSerializer, SerializerMethodField

from cars.carsharing.models.car import Car
from cars.carsharing.models.car_location import CarLocation
from cars.carsharing.models.car_model import CarModel
from cars.carsharing.models.car_telematics_state import CarTelematicsState
from cars.django.serializers import TimestampField


class CarLocationSerializer(ModelSerializer):

    updated_at = TimestampField()

    class Meta:
        model = CarLocation
        fields = [
            'course',
            'lat',
            'lon',
            'updated_at',
        ]


class CarModelSerializer(ModelSerializer):

    class Meta:
        model = CarModel
        fields = [
            'code',
            'manufacturer',
            'name',
            'video_url',
            'image_large_url',
            'image_small_url',
        ]


class CarTelematicsStateSerializer(ModelSerializer):

    class Meta:
        model = CarTelematicsState
        exclude = [
            'id',
            'car',
        ]

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field_name, field_value in self.fields.items():
            if isinstance(field_value, DateTimeField):
                self.fields[field_name] = TimestampField()


class SimpleCarSerializer(ModelSerializer):

    model = CarModelSerializer()

    class Meta:
        model = Car
        fields = [
            'id',
            'vin',
            'imei',
            'contract_id',
            'registration_id',
            'registration_date',
            'number',
            'model',
            'status',
            'fuel_card_number',
        ]
