from rest_framework.serializers import SerializerMethodField

from cars.django.serializers import BaseSerializer, TimestampField


class ChangelogDeltaViewArgumentsSerializer(BaseSerializer):

    timestamp = TimestampField(required=True)


class ChangeLogOrderItemSerializer(BaseSerializer):

    imei = SerializerMethodField()
    action_id = SerializerMethodField()
    car_id = SerializerMethodField()
    session_id = SerializerMethodField()
    user_id = SerializerMethodField()
    car_status = SerializerMethodField()
    timestamp = SerializerMethodField()

    def get_action_id(self, obj):
        return str(obj.id)

    def get_session_id(self, obj):
        return str(obj.order_id)

    def get_user_id(self, obj):
        return str(obj.order.user_id)

    def get_timestamp(self, obj):
        return obj.started_at.timestamp()

    def get_car_status(self, obj):
        return obj.type[11:]

    def get_car_id(self, obj):
        return str(obj.get_impl().car_id)

    def get_imei(self, obj):
        return str(obj.get_impl().car.imei)


class ChangeLogOrderCompletionSerializer(BaseSerializer):

    imei = SerializerMethodField()
    action_id = SerializerMethodField()
    car_id = SerializerMethodField()
    session_id = SerializerMethodField()
    user_id = SerializerMethodField()
    car_status = SerializerMethodField()
    timestamp = SerializerMethodField()

    def get_action_id(self, obj):
        return None

    def get_session_id(self, obj):
        return None

    def get_user_id(self, obj):
        return None

    def get_timestamp(self, obj):
        return obj.order.completed_at.timestamp()

    def get_car_status(self, obj):
        return 'available'

    def get_car_id(self, obj):
        return str(obj.get_impl().car_id)

    def get_imei(self, obj):
        return str(obj.get_impl().car.imei)
