from rest_framework.serializers import ModelSerializer, UUIDField, SerializerMethodField

from cars.django.serializers import BaseSerializer, TimestampField
from cars.fines.models import AutocodeFine, AutocodeFinePhoto

from .carsharing_simple import SimpleCarSerializer
from .order import OrderSerializer
from .user_simple import SimpleUserSerializer


class FineListArgumentsSerializer(BaseSerializer):
    user_id = UUIDField(required=False)
    car_id = UUIDField(required=False)


class FinePhotoSerializer(ModelSerializer):

    class Meta:
        model = AutocodeFinePhoto
        fields = [
            'id',
            'url',
        ]


class FineSerializer(ModelSerializer):
    car = SimpleCarSerializer()
    photos = FinePhotoSerializer(many=True, read_only=True)
    user = SimpleUserSerializer()

    violation_time = TimestampField()
    payment_confirmation_received_at = TimestampField()

    class Meta:
        model = AutocodeFine
        fields = [
            'id',
            'article_koap',
            'ruling_number',
            'ruling_date',
            'violation_time',
            'violation_place',
            'sum_to_pay',
            'payment_confirmation_received_at',
            'charged_at',
            'charge_passed_at',
            'charge_email_sent_at',
            'charge_sms_sent_at',
            'charge_push_sent_at',
            'needs_charge',
            'user',
            'car',
            'order',
            'photos',
        ]

    def get_order(self, fine):
        if fine.session_id:
            return {
                'id': fine.session_id,
                'created_at': None,
                'completed_at': None,
            }

        return OrderSerializer(fine.order).data
