from rest_framework.serializers import SerializerMethodField

from cars.bans.models.ban import Ban
from cars.carsharing.models.car_model import CarModel
from cars.django.serializers import BaseSerializer
from cars.users.models.user import User
from cars.users.models.user_documents import UserDocumentPhoto


class IntroSerializer(BaseSerializer):

    constants = SerializerMethodField()
    user = SerializerMethodField()

    def get_constants(self, _):
        constants = {
            'user_statuses': self._format_enum(User.Status),
            'photo_types': self._format_enum(UserDocumentPhoto.Type),
            'bans': {
                'reasons': self._format_enum(Ban.Reason),
            },
            'carsharing': {
                'car_models': [
                    {
                        'code': model.code,
                        'name': model.name,
                    }
                    for model in CarModel.objects.order_by('name')
                ],
            },
        }
        return constants

    def _format_enum(self, enum_class):
        return [
            {
                'name': x.name,
                'value': x.value,
            }
            for x in enum_class
        ]

    def get_user(self, request):
        user = request.user
        user_data = {
            'id': user.id,
            'username': user.username,
            'email': user.email,
            'groups': [
                {
                    'name': g.name
                }
                for g in user.groups.all()
            ],
            'permissions' : user.get_all_permissions(),
        }
        return user_data
