from rest_framework.serializers import ChoiceField, ListField

from cars.django.serializers import BaseSerializer
from cars.users.models.user_documents import UserDocumentPhoto


class RegistrationResubmitPhotosArgumentsSerializer(BaseSerializer):

    photo_types = ListField(
        child=ChoiceField(choices=[(x.value, x.name) for x in UserDocumentPhoto.Type]),
        min_length=1,
    )
