from rest_framework.serializers import (
    CharField, DecimalField, ModelSerializer, SerializerMethodField,
)

from cars.billing.models.bonus_account import BonusAccount, BonusAccountOperation
from cars.django.serializers import BaseSerializer
from .user_simple import SimpleUserSerializer


class UserBonusAccountArgumentsSerializer(BaseSerializer):

    amount = DecimalField(max_digits=10, decimal_places=2)
    comment = CharField()
    nonce = CharField()


class UserBonusAccountSerializer(ModelSerializer):

    generic = SerializerMethodField()
    registration_taxi_cashback = SerializerMethodField()

    class Meta:
        model = BonusAccount
        fields = [
            'balance',
            'generic',
            'registration_taxi_cashback',
        ]

    def get_generic(self, obj):
        return {
            'earned': str(obj.generic_earned),
            'spent': str(obj.generic_spent),
        }

    def get_registration_taxi_cashback(self, obj):
        return {
            'earned': str(obj.registration_taxi_cashback_earned),
            'spent': str(obj.registration_taxi_cashback_spent),
        }


class UserBonusAccountOperationSerializer(ModelSerializer):

    created_by = SimpleUserSerializer()

    class Meta:
        model = BonusAccountOperation
        fields = '__all__'
