from rest_framework.serializers import CharField, DateTimeField, SerializerMethodField

from cars.django.serializers import BaseSerializer


class BaseDocumentTextDataSerializer(BaseSerializer):

    first_name = CharField(default=None)
    last_name = CharField(default=None)
    patronymic_name = CharField(default=None, source='middle_name')
    birth_date = DateTimeField(default=None, format="%Y-%m-%d %H:%M:%S")
    issue_date = DateTimeField(default=None)


class RegistrationTextDataSerializer(BaseSerializer):

    region = CharField(default=None, source='registration_region')
    area = CharField(default=None, source='registration_area')
    locality = CharField(default=None, source='registration_locality')
    street = CharField(default=None, source='registration_street')
    house = CharField(default=None, source='registration_house')
    housing = CharField(default=None, source='registration_housing')
    apartment = CharField(default=None, source='registration_apartment')


class PassportTextDataSerializer(BaseDocumentTextDataSerializer):

    birth_place = CharField(default=None)
    gender = CharField(default=None)
    citizenship = CharField(default=None)
    subdivision_code = CharField(default=None)
    expiration_date = CharField(default=None)

    number = CharField(default=None, source='doc_value')

    registration = SerializerMethodField()

    def get_registration(self, obj):
        return RegistrationTextDataSerializer(obj).data


class DrivingLicenseTextDataSerializer(BaseDocumentTextDataSerializer):

    number = CharField(default=None)
    categories = CharField(default=None)
    categories_b_valid_from_date = DateTimeField(default=None)
    categories_b_valid_to_date = DateTimeField(default=None)
    prev_licence_number = CharField(default=None)
    prev_licence_issue_date = DateTimeField(default=None)
    experience_from = DateTimeField(default=None)


# Serializers for edit documents data scenario

class PassportTextDataEditSerializer(BaseDocumentTextDataSerializer):

    birth_place = CharField(default=None)
    gender = CharField(default=None)
    citizenship = CharField(default=None)
    subdivision_code = CharField(default=None)

    number = CharField(default=None, source='doc_value')

    registration = RegistrationTextDataSerializer()


class UserDocumentsTextDataUpdateSerializer(BaseSerializer):

    passport = PassportTextDataEditSerializer(required=True)
    driving_license = DrivingLicenseTextDataSerializer(required=True)
