from rest_framework.serializers import ModelSerializer, SerializerMethodField

from cars.django.serializers import TimestampField
from cars.users.models import User
from .user_registration_state import UserRegistrationStateSerializer


class SimpleUserSerializer(ModelSerializer):

    uid = SerializerMethodField()
    username = SerializerMethodField()
    email = SerializerMethodField()
    phone = SerializerMethodField()
    first_name = SerializerMethodField()
    last_name = SerializerMethodField()
    patronymic_name = SerializerMethodField()

    class Meta:
        model = User
        fields = [
            'id',
            'uid',
            'username',
            'email',
            'phone',
            'status',
            'first_name',
            'last_name',
            'patronymic_name',
        ]

    def get_uid(self, obj):
        return obj.uid if obj.status != 'deleted' else None

    def get_username(self, obj):
        return obj.username if obj.status != 'deleted' else None

    def get_email(self, obj):
        return obj.email if obj.status != 'deleted' else None

    def get_phone(self, obj):
        return str(obj.phone) if obj.status != 'deleted' and obj.phone else None

    def get_is_phone_verified(self, obj):
        return obj.is_phone_verified if obj.status != 'deleted' else None

    def get_first_name(self, obj):
        return obj.first_name if obj.status != 'deleted' else None

    def get_last_name(self, obj):
        return obj.last_name if obj.status != 'deleted' else None

    def get_patronymic_name(self, obj):
        return obj.patronymic_name if obj.status != 'deleted' else None
