from rest_framework.serializers import CharField, ListField

from cars.django.serializers import BaseSerializer


class UserTagsArgumentsSerializer(BaseSerializer):

    tags = ListField(child=CharField(), required=True)

    def validate_tags(self, value):
        value = [t.strip().lower() for t in value]
        return value
