# pylint: disable=line-too-long
from django.conf.urls import url

from . import views
from cars.django.views import GoneView


app_name = 'admin'
urlpatterns = [
    url(
        r'^autocode/driving-license-data/$',
        views.AutoDrivingLicenseView.as_view(),
        name='driving-license-data',
    ),
    url(
        r'^call/(?P<action>(start|connect|finish))_call/$',
        views.SimplifiedRegisterCallView.as_view(),
        name='register-call',
    ),
    url(
        r'^call/register_call/$',
        views.GenericRegisterCallView.as_view(),
        name='register-call-generic',
    ),
    url(
        r'^call/get_assigned_call/$',
        views.AssignedCallView.as_view(),
        name='get-assigned-call',
    ),
    url(
        r'^call/get_all_assigned_calls/$',
        views.AllAssignedCallsView.as_view(),
        name='get-all-assigned-calls',
    ),
    url(
        r'^call/get_all_operators/$',
        views.AllOperatorsView.as_view(),
        name='get-all-operators',
    ),
    url(
        r'^call/priority_user/check/$',
        views.PriorityUserView.as_view(),
        name='call-priority-user-check-phone',
    ),
    url(
        r'^call/priority_users/$',
        views.AllPriorityUsersView.as_view(),
        name='call-priority-users',
    ),
    url(
        r'^call/blacklist/add/$',
        views.CallBlacklistAddPhoneView.as_view(),
        name='call-blacklist-add-phone',
    ),
    url(
        r'^call/blacklist/remove/$',
        views.CallBlacklistRemovePhoneView.as_view(),
        name='call-blacklist-remove-phone',
    ),
    url(
        r'^call/blacklist/check/$',
        views.CallBlacklistCheckPhoneView.as_view(),
        name='call-blacklist-check-phone',
    ),
    url(
        r'^call/blacklist/history/$',
        views.CallBlacklistHistoryView.as_view(),
        name='call-blacklist-history',
    ),
    url(
        r'^call/settings/load_balance_calendar/$',
        views.CallCenterLoadBalanceCalendarView.as_view(),
        name='call-settings-load-balance-calendar',
    ),
    url(r'^cars/(?P<car_id>[\w-]+)/$', views.CarDetailsView.as_view(), name='car-details'),
    url(
        r'^cars/(?P<car_id>[\w-]+)/status/available/$',
        views.MoveToAvailableCarStatusView.as_view(),
        name='car-status-available',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/status/service/$',
        views.MoveToServiceCarStatusView.as_view(),
        name='car-status-service',
    ),
    url(
        r'^cars/documents/assignments/$',
        views.CarDocumentAssignmentsListView.as_view(),
        name='car-document-assignments',
    ),
    url(
        r'^cars/documents/list/$',
        views.CarDocumentsListView.as_view(),
        name='car-documents',
    ),
    url(
        r'^cars/documents/sim-cards/$',
        views.CarDocumentSimView.as_view(),
        name='car-documents-sim',
    ),
    url(
        r'^cars/documents/upload-insurance/$',
        views.CarInsuranceUploadView.as_view(),
        name='cars-insurance-upload',
    ),
    url(
        r'^cars/documents/upload-file/$',
        views.CarDocumentFileUploadView.as_view(),
        name='cars-document-file-upload',
    ),
    url(r'^constants/$', views.ConstantsView.as_view(), name='constants'),
    url(r'^fines/$', views.FineListView.as_view(), name='fine-list'),
    url(r'^fines/(?P<fine_id>[\w-]+)/resend_email/$', views.FineNotifications.as_view(),
        name='fine-resend-email'),
    url(r'^fuel-card-usages/$', views.FuelCardUsagesView.as_view(), name='fuel-card-usages'),
    url(
        r'^incident/evacuation/$',
        views.EvacuationView.as_view(),
        name='incident-evacuation'
    ),
    url(r'^intro/$', views.IntroView.as_view(), name='intro'),
    url(
        r'^orders/$',
        GoneView.as_view(),  # views.OrderListView.as_view(),
        name='order-list',
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/$',
        GoneView.as_view(),  # views.OrderDetailsView.as_view(),
        name='order-details',
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/finish/$',
        GoneView.as_view(),  # views.OrderFinishView.as_view(),
        name='order-finish',
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/finish-force/$',
        GoneView.as_view(),  # views.OrderFinishNoTelematicsView.as_view(),
        name='order-finish-force',
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/forgive-debt/$',
        GoneView.as_view(),  # views.OrderDebtForgiveView.as_view(),
        name='order-debt-forgive',
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/refund/$',
        GoneView.as_view(),  # views.RefundOrderView.as_view(),
        name='order-refund',
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/items/(?P<order_item_id>[\w-]+)/refund/$',
        GoneView.as_view(),  # views.RefundOrderItemView.as_view(),
        name='order-item-refund',
    ),
    url(
        r'^orders/(?P<order_id>[\w-]+)/restart-payment/$',
        GoneView.as_view(),  # views.OrderRestartPaymentView.as_view(),
        name='order-restart-payment',
    ),
    url(
        r'^trust/payments/(?P<purchase_token>\w+)/$',
        views.TrustProxyPaymentView.as_view(),
        name='trust-proxy-payment',
    ),
    url(
        r'^user-tags/$',
        views.UserTagListView.as_view(),
        name='user-tag-list'
    ),
    url(r'^users/$', views.UserListView.as_view(), name='user-list'),
    url(r'^users/phone-history/$', views.UserPhoneHistoryView.as_view(), name='user-phone-history'),
    url(r'^users/(?P<user_id>[\w-]+)/$', views.UserDetailsView.as_view(), name='user-details'),
    url(
        r'^users/(?P<user_id>[\w-]+)/bans/$',
        views.UserBanListView.as_view(),
        name='user-ban-list',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/bonus-account/operations/$',
        views.UserBonusAccountOperationListView.as_view(),
        name='user-bonus-account-operation-list',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/commands/block/$',
        views.BlockUserView.as_view(),
        name='user-block',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/commands/unblock/$',
        views.UnblockUserView.as_view(),
        name='user-unblock',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/documents/(?P<document_id>[\w-]+)/photos/(?P<photo_id>[\w-]+)/content/$',
        views.UserDocumentPhotoContentView.as_view(),
        name='user-document-photo-content',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/documents/(?P<document_id>[\w-]+)/photos/(?P<photo_id>[\w-]+)/thumbnail/$',
        views.UserDocumentPhotoThumbnailView.as_view(),
        name='user-document-photo-thumbnail',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/documents/(?P<document_id>[\w-]+)/photos/(?P<photo_id>[\w-]+)/background-video/$',
        views.UserDocumentPhotoBackgroundVideoView.as_view(),
        name='user-document-photo-background-video',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/payment-methods/$',
        views.UserPaymentMethodsView.as_view(),
        name='user-payment-methods',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/registration/approve/$',
        views.RegistrationApproveView.as_view(),
        name='user-registration-approve',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/registration/approve-rejected/$',
        views.RegistrationApproveRejectedView.as_view(),
        name='user-registration-approve-rejected',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/registration/reject/$',
        views.RegistrationRejectView.as_view(),
        name='user-registration-reject',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/registration/resubmit-photos/$',
        views.RegistrationResubmitPhotosView.as_view(),
        name='user-registration-resubmit-photos',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/registration/debug/reset/$',
        views.RegistrationResetDebugView.as_view(),
        name='user-registration-debug-reset',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/resend-for-verification/$',
        views.ResendUserForVerification.as_view(),
        name='resend-for-verification',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/send-evacuation-notification/$',
        views.SendEvacuationNotificationView.as_view(),
        name='send-evacuation-notification',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/send-inner-fine-notification/$',
        views.SendInnerFineNotificationView.as_view(),
        name='send-inner-fine-notification',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/tags/$',
        views.UserTagsView.as_view(),
        name='user-tags',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/yang-assignments/$',
        views.UserYangVerificationHistoryView.as_view(),
        name='yang-assignments-history',
    ),
    url(
        r'^chat/proxy/$',
        views.UserChatProxyView.as_view(),
        name='user-chat-proxy',
    ),
    url(
        r'^user-by-yang-id/(?P<secret_id>[\w-]+)/$',
        views.UserIdByYangIdView.as_view(),
        name='user-by-yang-id',
    ),
    url(
        r'^users/push/$',
        views.UserListPushView.as_view(),
        name='user-list-push',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/push/$',
        views.UserPushView.as_view(),
        name='user-push',
    ),

    # Gone views

    url(
        r'^call/get_all_stat_access_operators/$',
        GoneView.as_view(),  # views.AllStatAccessOperatorsView.as_view(),
        name='get-all-stat-access-operators',
    ),
    url(
        r'^call/get_operators_without_stat_access/$',
        GoneView.as_view(),  # views.OperatorsWithoutStatAccessView.as_view(),
        name='get-operators-without-stat-access',
    ),
    url(
        r'^car-info-by-imei/status/$',
        GoneView.as_view(),  # views.CarStatusByIMEIView.as_view(),
        name='car-status-by-imei',
    ),
    url(
        r'^car-info-by-imei/ride/$',
        GoneView.as_view(),  # views.CarRideByIMEIView.as_view(),
        name='car-ride-by-imei'
    ),
    url(
        r'^car-info-by-imei/by-time/$',
        GoneView.as_view(),  # views.CarInfoByIMEIByTimeView.as_view(),
        name='car-info-by-imei-on-time'
    ),
    url(
        r'^car-models/$',
        GoneView.as_view(),  # views.CarModelListView.as_view(),
        name='car-model-list'
    ),
    url(
        r'^cars/$',
        GoneView.as_view(),  # views.CarListView.as_view(),
        name='car-list'
    ),
    url(
        r'^cars/statuses/$',
        GoneView.as_view(),  # views.CarStatusesListView.as_view(),
        name='car-statuses-list'
    ),
    url(
        r'^cars-transport-feed/$',
        GoneView.as_view(),  # views.CarListTransportFeedView.as_view(),
        name='car-transport-feed'
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/acceptance-photos/$',
        GoneView.as_view(),  # views.CarAcceptancePhotosView.as_view(),
        name='car-details'
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/documents/(?P<document_id>[\w-]+)/detach/$',
        GoneView.as_view(),  # views.CarDocumentDetachView.as_view(),
        name='car-document-detach',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/assembly-photos/$',
        GoneView.as_view(),  # views.CarAssemblyPhotosView.as_view(),
        name='car-assembly-photos'
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/commands/open/$',
        GoneView.as_view(),  # views.OpenCarCommandView.as_view(),
        name='car-command-open',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/commands/close/$',
        GoneView.as_view(),  # views.CloseCarCommandView.as_view(),
        name='car-command-close',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/commands/lock-hood/$',
        GoneView.as_view(),  # views.LockHoodCommandView.as_view(),
        name='car-command-lock-hood',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/commands/unlock-hood/$',
        GoneView.as_view(),  # views.UnlockHoodCommandView.as_view(),
        name='car-command-unlock-hood',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/fuel-card-activate/$',
        GoneView.as_view(),  # views.ActivateFuelCardView.as_view(),
        name='car-fuel-card-activate',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/fuel-card-block/$',
        GoneView.as_view(),  # views.BlockFuelCardView.as_view(),
        name='car-fuel-card-block',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/fuel-card-number/$',
        GoneView.as_view(),  # views.UpdateFuelCardNumberView.as_view(),
        name='car-fuel-card-update',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/tags/(?P<tag_id>[\w-]+)/photos/$',
        GoneView.as_view(),  # views.CarTagPhotosView.as_view(),
        name='car-tag-photos'
    ),
    url(
        r'^cars/documents/create-by-vin/$',
        GoneView.as_view(),  # views.CreateCarsByVINNumbersView.as_view(),
        name='cars-upload-basic',
    ),
    url(
        r'^carsharing/tariff-plans/$',
        GoneView.as_view(),  # views.CarsharingTariffPlanListView.as_view(),
        name='carsharing-tariff-plan-list',
    ),
    url(
        r'^carsharing/tariff-plans/(?P<tariff_plan_id>[\w-]+)/$',
        GoneView.as_view(),  # views.CarsharingTariffPlanDetailsView.as_view(),
        name='carsharing-tariff-plan-details',
    ),
    url(
        r'^changelog/$',
        GoneView.as_view(),  # views.ChangelogDeltaView.as_view(),
        name='changelog'
    ),
    url(
        r'^push-presets/$',
        GoneView.as_view(),  # views.PushPresetListView.as_view(),
        name='push-preset-list',
    ),
    url(
        r'^push-presets/new/$',
        GoneView.as_view(),  # views.PushPresetModifyView.as_view(),
        name='push-preset-create',
    ),
    url(
        r'^push-presets/(?P<preset_id>[\w-]+)/$',
        GoneView.as_view(),  # views.PushPresetModifyView.as_view(),
        name='push-preset-modify',
    ),
    url(
        r'^telematics/signals/$',
        GoneView.as_view(),  # views.TelematicsSignalsView.as_view(),
        name='telematics-signals',
    ),
    url(
        r'^role/$',
        GoneView.as_view(),  # views.CurrentUserRoleView.as_view(),
        name='current-user-role',
    ),
    url(
        r'^users/new/$',
        GoneView.as_view(),  # views.UserCreateView.as_view(),
        name='user-create'
    ),
    url(
        r'^users/push-preset/$',
        GoneView.as_view(),  # views.UserListPushPresetView.as_view(),
        name='user-list-push-preset',
    ),
    url(
        r'^users/statuses/$',
        GoneView.as_view(),  # views.UserStatusListView.as_view(),
        name='user-status-list'
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/bonus-account/credit/$',
        GoneView.as_view(),  # views.CreditUserBonusAccountView.as_view(),
        name='user-bonus-account-credit',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/bonus-account/debit/$',
        GoneView.as_view(),  # views.DebitUserBonusAccountView.as_view(),
        name='user-bonus-account-debit',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/documents/(?P<document_id>[\w-]+)/photos/(?P<photo_id>[\w-]+)/background-video/upload/$',
        GoneView.as_view(),  # views.UserDocumentPhotoBackgroundVideoUploaderView.as_view(),
        name='user-document-photo-background-video-upload',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/documents/(?P<document_id>[\w-]+)/photos/(?P<photo_id>[\w-]+)/background-video/convert/$',
        views.UserDocumentPhotoBackgroundVideoConverterView.as_view(),
        name='user-document-photo-background-video-convert',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/push-preset/$',
        GoneView.as_view(),  # views.UserPushPresetView.as_view(),
        name='user-push-preset',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/request-phone-verification/$',
        GoneView.as_view(),  # views.UserPhoneSetUnverifiedView.as_view(),
        name='user-request-phone-verification',
    ),
    url(
        r'^users/(?P<user_id>[\w-]+)/update-textdata/$',
        GoneView.as_view(),  # views.UserDocumentsTextDataUpdateView.as_view(),
        name='user-textdata-update',
    ),
]
