import logging

from rest_framework.response import Response

from cars.core.authorization import DrivePermissionAPIView, DriveActionPermissionFactory
from cars.core.autocode import (
    AutoCodeAuthentication,
    AutoCodeDrivingLicenseVerifier
)
from cars.core.util import make_yt_client
from ..serializers.autocode import (
    AutoCodeDrivingLicenseArgumentsSerializer
)


LOGGER = logging.getLogger(__name__)


class AutoDrivingLicenseView(DrivePermissionAPIView):
    action_permission_classes = [DriveActionPermissionFactory.build('support_py_reg')]

    autocode = AutoCodeDrivingLicenseVerifier(
        auth=AutoCodeAuthentication.from_settings(),
        request_timeout=8,
        retries=0,
        yt_client=make_yt_client('data'),
    )

    arguments_serializer_class = AutoCodeDrivingLicenseArgumentsSerializer

    def do_get(self, request, *args, **kwargs):  # pylint: disable=unused-argument
        raw_response = self.autocode.get_driving_license_data(
            license_number=request.arguments['number'],
            issue_date=request.arguments['issue_date'],
        )
        return Response(raw_response)
