import logging

from rest_framework.response import Response

from cars.core.authorization import DrivePermissionAPIView, DriveActionPermissionFactory
from cars.orders.models import Order, OrderItem, OrderItemPayment


LOGGER = logging.getLogger(__name__)


class OrderDebtForgiveView(DrivePermissionAPIView):
    action_permission_classes = [DriveActionPermissionFactory.build(('support_py_general', 'support_py_sup_general'), require_all=False)]

    def do_post(self, request, order_id):  # pylint:disable=unused-argument
        order_items = OrderItem.objects.filter(order_id=order_id)
        for item in order_items:
            payment = OrderItemPayment.objects.filter(order_item_id=item.id).order_by('-created_at').first()
            if payment is not None:
                payment = payment.get_impl()
                payment.status = 'cleared'
                payment.save()

        order = Order.objects.get(id=order_id)
        order.status = 'success'
        order.save()

        user = order.user
        if user.status == 'debt':
            user.status = 'active'
            user.save()

        return Response()
