from rest_framework.response import Response

from cars.orders.models import OrderItem
from ..serializers.changelog import (
    ChangeLogOrderItemSerializer,
    ChangeLogOrderCompletionSerializer,
    ChangelogDeltaViewArgumentsSerializer,
)
from .base import AdminAndCallcenterAPIView


class ChangelogDeltaView(AdminAndCallcenterAPIView):

    arguments_serializer_class = ChangelogDeltaViewArgumentsSerializer

    permission_classes = []

    def get_queryset(self):
        return OrderItem.objects

    def do_get(self, request, *args, **kwargs):  # pylint: disable=unused-argument
        in_order_status_transitions_qs = (
            OrderItem.objects.with_related()
            .filter(started_at__gte=request.arguments['timestamp'])
            .select_related('order')
        )
        in_order_status_transitions = [
            ChangeLogOrderItemSerializer(x).data for x in in_order_status_transitions_qs.all()
        ]

        order_completion_status_transitions_qs = (
            OrderItem.objects.with_related()
            .filter(
                type=OrderItem.Type.CARSHARING_RESERVATION.value,  # deduplicate
                order__completed_at__gte=request.arguments['timestamp']
            )
            .select_related('order')
        )
        order_completion_status_transitions = [
            ChangeLogOrderCompletionSerializer(x).data for x in order_completion_status_transitions_qs.all()
        ]

        return Response(order_completion_status_transitions + in_order_status_transitions)

    def _check_acl(self, user):
        return True
