from rest_framework.response import Response

from cars.core.authorization import DrivePermissionAPIView, DriveActionPermissionFactory
from cars.carsharing.models.car_model import CarModel
from cars.users.models.user import User
from cars.users.models.user_documents import UserDocumentPhoto


class ConstantsView(DrivePermissionAPIView):
    action_permission_classes = [DriveActionPermissionFactory.build(('support_py_all_general', 'support_py_sup_general', 'support_py_general'), require_all=False)]

    def do_get(self, _):
        data = {
            'user_statuses': self._format_enum(User.Status),
            'photo_types': self._format_enum(UserDocumentPhoto.Type),
            'carsharing': {
                'car_models': [
                    {
                        'code': model.code,
                        'name': model.name,
                    }
                    for model in CarModel.objects.order_by('name')
                ],
            },
        }
        return Response(data)

    def _format_enum(self, enum_class):
        return [
            {
                'name': x.name,
                'value': x.value,
            }
            for x in enum_class
        ]
