from rest_framework.mixins import ListModelMixin
from cars.django.pagination import Pagination
from cars.eka.models import FuelCardActivation
from ..serializers.fuel_card import (
    FuelCardActivationUsagesViewArgumentsSerializer,
    FuelCardActivationSerializer
)
from cars.core.authorization import DrivePermissionAPIView, DriveActionPermissionFactory


class FuelCardUsagesView(ListModelMixin, DrivePermissionAPIView):
    action_permission_classes = [DriveActionPermissionFactory.build(('support_py_all_general', 'support_py_sup_general', 'support_py_general'), require_all=False)]

    pagination_class = Pagination
    serializer_class = FuelCardActivationSerializer

    arguments_serializer_class = FuelCardActivationUsagesViewArgumentsSerializer

    def get_queryset(self):
        qs = (
            FuelCardActivation.objects
            .order_by(
                '-activated_at'
            )
            .select_related('bonus_account_operation')
        )

        id_filter = {}
        if 'user_id' in self.request.arguments:
            id_filter['order__user_id'] = self.request.arguments['user_id']
        if 'car_id' in self.request.arguments:
            id_filter['car_id'] = self.request.arguments['car_id']
        if 'order_id' in self.request.arguments:
            id_filter['order_id'] = self.request.arguments['order_id']

        if id_filter:
            qs = qs.filter(**id_filter)

        return qs

    def do_get(self, request, *args, **kwargs):
        return self.list(request, *args, **kwargs)
