import logging

from rest_framework.status import HTTP_400_BAD_REQUEST
from rest_framework.response import Response

from cars.core.authorization import DrivePermissionAPIView, DriveActionPermissionFactory
from cars.drive.core.incident import EvacuationManagementHelper, EvacuationException
from cars.drive.serializers.incident import EvacuationInfoSerializer


LOGGER = logging.getLogger(__name__)


class EvacuationView(DrivePermissionAPIView):
    action_permission_classes = [DriveActionPermissionFactory.build('support_py_eva')]

    evacuation_manager = EvacuationManagementHelper.from_settings()

    def do_post(self, request):
        serializer = EvacuationInfoSerializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        data = serializer.validated_data

        try:
            response_data = self.evacuation_manager.add_evacuation_info(data=data, request=request)
        except EvacuationException as exc:
            return Response(
                status=HTTP_400_BAD_REQUEST,
                data=exc.data
            )

        return Response(response_data)
