from rest_framework.response import Response

from ..serializers.intro import IntroSerializer
from cars.core.authorization import DrivePermissionAPIView, DriveActionPermissionFactory


class IntroView(DrivePermissionAPIView):
    action_permission_classes = [DriveActionPermissionFactory.build(('support_py_all_general', 'support_py_sup_general', 'support_py_general'), require_all=False)]

    def do_get(self, request):
        data = IntroSerializer(request).data
        return Response(data)
