from rest_framework.response import Response
from rest_framework.status import HTTP_403_FORBIDDEN

from .base import AdminAndCallcenterAPIView


class CurrentUserRoleView(AdminAndCallcenterAPIView):

    def do_get(self, request, *args, **kwargs):  # pylint: disable=unused-argument
        if self.acl is None or request.user.uid in self.acl:
            return Response({'role': 'admin'})
        if self.internal_callcenter_acl is None or request.user.uid in self.internal_callcenter_acl:  # pylint: disable=line-too-long
            return Response({'role': 'support'})
        return Response(status=HTTP_403_FORBIDDEN)
