import logging

from rest_framework.exceptions import NotFound
from rest_framework.response import Response

from cars.carsharing.core.telematics_state_updater import TelematicsStateUpdater
from cars.django.util import ReqAnsLogger
from ..serializers.telematics_signals import TelematicsSignalsArgumentsSerializer
from .base import AdminAPIView


LOGGER = logging.getLogger(__name__)


class TelematicsSignalsView(AdminAPIView):

    permission_classes = []

    arguments_serializer_class = TelematicsSignalsArgumentsSerializer
    reqans_logger_policy = ReqAnsLogger.Policy.NONE

    def do_post(self, request):
        imei = request.arguments['imei']
        packet = request.arguments['packet']

        updater = TelematicsStateUpdater(imei=imei)

        try:
            updater.update_from_raw_packet(packet=packet)
        except updater.CarDoesNotExistError:
            LOGGER.error('telematics signal for an unknown car with imei %s: %s', imei, packet)
            raise NotFound

        return Response()

    def _check_acl(self, user):
        return True
