from rest_framework.response import Response

from cars.core.trust import TrustClient

from cars.users.models.user import User
from ..core.push_client import PUSH_CLIENT

from cars.core.authorization import DrivePermissionAPIView, DriveActionPermissionFactory


class UserPaymentMethodsView(DrivePermissionAPIView):
    action_permission_classes = [DriveActionPermissionFactory.build('support_py_payment')]

    lookup_url_kwarg = 'user_id'
    queryset = User.objects.all()

    _trust = TrustClient.from_settings(push_client=PUSH_CLIENT)

    def do_get(self, request, user_id):  # pylint: disable=unused-argument
        user = self.get_object()
        data = self._trust.get_payment_methods(uid=user.uid)
        return Response(data)
