from django.conf import settings

from .static_data import CITIES, CLIENTS


class RequestCityMiddleware(object):

    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        city_code = request.META.get(settings.CITY_HEADER)
        if city_code is not None:
            try:
                city_code = int(city_code)
            except Exception:
                city_code = None

        request.city = CITIES.get(city_code)

        try:
            response = self.get_response(request)
        except Exception:  # need to debug exception TODO: fix and remove
            raise RuntimeError('get response from request failed: {}'.format(
                vars(request)
            ))

        return response


class RequestClientMiddleware(object):

    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        client_name = request.META.get(settings.CLIENT_HEADER)
        request.client = CLIENTS.get(client_name)
        response = self.get_response(request)
        return response


class LocaleProxyMiddleware(object):
    '''Copy contents of the Lang header to Accept-Language'''

    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        lang = request.META.get(settings.LANG_HEADER)
        if lang:
            request.META['HTTP_ACCEPT_LANGUAGE'] = lang
        response = self.get_response(request)
        return response
