import shapely
from rest_framework import serializers

from .common import PushTokenParameterMixin, validate_geojson_point
from .filter import CarFilterSerializer


class BaseAlertSerializer(PushTokenParameterMixin, serializers.Serializer):
    pass


class AlertSubscriptionSerializer(BaseAlertSerializer):
    location = serializers.JSONField()
    walk_time = serializers.FloatField(min_value=30, max_value=3600)
    filters = CarFilterSerializer()

    def validate_location(self, value):
        return validate_geojson_point(value)


class AlertCancellationSerializer(BaseAlertSerializer):
    pass
