import os

import furl
from django.conf import settings
from django.utils import translation
from rest_framework import serializers

from cars.django.serializers import BaseSerializer


class CarModelSerializer(BaseSerializer):
    short_name = serializers.CharField()
    seats = serializers.IntegerField()
    name = serializers.SerializerMethodField()
    fuel_type = serializers.SerializerMethodField()

    image_url = serializers.SerializerMethodField()

    def get_image_url(self, obj):
        filename = '{}.png'.format(obj.short_name)
        path = os.path.join(settings.STATIC_URL, 'model-images', filename)
        args = {
            'rev': 3,
        }
        request = self.context['request']
        img_url = request.build_absolute_uri(path)
        img_url = furl.furl(img_url).set(args=args).url
        return img_url

    def get_name(self, obj):
        return obj.localized_name(translation)

    def get_fuel_type(self, obj):
        return obj.localized_fuel_type(translation)
