import shapely
from rest_framework import serializers


class PushTokenParameterMixin(serializers.Serializer):

    PLATFORMS = {'android', 'ios'}

    platform = serializers.CharField()
    device_id = serializers.CharField()

    def validate_platform(self, value):
        value = value.lower()
        if value not in {'android', 'ios'}:
            raise serializers.ValidationError('Unknown platform: {}'.format(value))
        return value


def validate_point(value):
    try:
        lon, lat = [float(coord) for coord in value.split(',')]
    except Exception:
        raise serializers.ValidationError('Invalid value: {}'.format(value))
    return lon, lat


def validate_geojson_point(value):
    try:
        shape = shapely.geometry.shape(value)
        assert isinstance(shape, shapely.geometry.Point)
    except Exception:
        raise serializers.ValidationError('Invalid GeoJSON point: {}'.format(value))
    return value
