from rest_framework import serializers

from .common import PushTokenParameterMixin, validate_geojson_point


class TaxiSendCodeParametersSerializer(PushTokenParameterMixin, serializers.Serializer):
    pass


class TaxiMakeOrderParametersSerializer(PushTokenParameterMixin, serializers.Serializer):
    code = serializers.CharField()
    source = serializers.JSONField()
    destination = serializers.JSONField()

    def validate_source(self, value):
        return validate_geojson_point(value)

    def validate_destination(self, value):
        return validate_geojson_point(value)
