ymaps.ready(function () {
    ymaps.geolocation.get().then(function (res) {
        var map = new ymaps.Map('map', {
            center: res.geoObjects.position,
            zoom: 14,
            controls: []
        });
        var hasEndPoint = false;

        var myGeoObjects = new ymaps.GeoObjectCollection({}, {});

        var myLocation = new ymaps.Placemark(res.geoObjects.position, {
            iconCaption: "Start"
        }, {
            preset: 'islands#greenDotIconWithCaption',
            draggable: true
        });
        myGeoObjects.add(myLocation);
        map.geoObjects.add(myGeoObjects);

        map.events.add('click', function (e) {
            if (!hasEndPoint) {
                var pointCoords = e.get('coords'),
                    targetPoint = new ymaps.Placemark(pointCoords, {
                        iconCaption: "End"
                    }, {
                        preset: 'islands#redDotIconWithCaption',
                        draggable: true
                    });
                console.log(pointCoords);
                //map.geoObjects.add(targetPoint);
                myGeoObjects.add(targetPoint);
                hasEndPoint = true;
            }
        });
        map.events.add('dblclick', function (e) {
            axios.post('/apiTestDblClick')
                .catch(err => {
                    console.info(err);
                    Raven.captureException(err);
                })
        });

        var btn = document.querySelector('.btn');
        btn.addEventListener('click', function (e) {
            if (!hasEndPoint) {
                alert('Нет 2й точки');
                return;
            }

            var token = prompt('Token');
            if (token) {
                console.log('token:', token, myGeoObjects.toArray());
                var points = myGeoObjects.toArray().map(function (point) {
                    //point.properties.get('iconCaption')
                    return point.geometry.getCoordinates();
                });

                axios.post('/aggregator/api/carsharing/taxi/send_code/', {"platform": "ios", "device_id": token})
                    .then(function (response) {
                        console.log(response);
                        var password = prompt('Token:' + token + ';\nCoordinates:' + JSON.stringify(points));
                        if (password) {
                            axios.post('/aggregator/api/carsharing/taxi/orders/',
                                {
                                    "device_id": token,
                                    "platform": "ios",
                                    "source": {
                                        "type": "Point",
                                        "coordinates": points[0]
                                    },
                                    "destination": {
                                        "type": "Point",
                                        "coordinates": points[1]
                                    },
                                    "code": password
                                })
                                .then(function (response) {
                                    console.log(JSON.stringify(response.data));
                                    alert(JSON.stringify(response.data));
                                })
                                .catch(err => {
                                    alert('ERR:', JSON.stringify(err));
                                    Raven.captureException(err);
                                });
                        }
                    }).catch(err => {
                    alert('ERR:', JSON.stringify(err));
                    Raven.captureException(err);
                });
            }
            else {
                console.log('--', token);
            }
        })
    });
});
/*
 curl -X POST -d '{"device_id":"b609841acf7e3cd4cbdd15269162096464284029a180178e3bc20f9e36b6c3ac","platform":"ios"}'
 -H "Content-Type: application/json" "https://carsharing-api.yandex.net/aggregator/api/carsharing/taxi/send_code/"
* */