# pylint: disable=line-too-long
from cars.core.models.car_model import CarModel
from . import operators
from . import car_models


PHOTOS = {
    operators.ANYTIME.short_name: {
        car_models.BMW_116I.short_name: 'https://avatars.mds.yandex.net/get-serp/34166/043f6b1d-38d8-4274-8d6c-f083674f4717/orig',
        car_models.KIA_RIO.short_name: 'https://avatars.mds.yandex.net/get-serp/15230/60591118-1b8d-4b2c-bbe9-fb9a7ea6d2b9/orig',
        car_models.RENAULT_KANGOO.short_name: 'https://avatars.mds.yandex.net/get-serp/34166/9afc5567-0976-4213-a430-d74d155c2da8/orig',
        car_models.SOLARIS.short_name: 'https://avatars.mds.yandex.net/get-serp/39011/2e30335b-93aa-469d-af51-41909243cad8/orig',
    },
    operators.BELKA.short_name: {
        car_models.FORD_FIESTA.short_name: 'https://avatars.mds.yandex.net/get-serp/28672/5d3c3031-7f77-4560-b184-df4479cc6ae8/orig',
        car_models.KIA_RIO.short_name: 'https://avatars.mds.yandex.net/get-serp/28672/5d3c3031-7f77-4560-b184-df4479cc6ae8/orig',
        car_models.MERCEDES_BENZ.short_name: 'https://avatars.mds.yandex.net/get-mobile-metro/469512/BelkaCarBlack/orig',
        car_models.KIA_RIO_X_LINE.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/759349/belka_xline/orig',
    },
    operators.CAR5.short_name: {
        car_models.DATSUN.short_name: 'https://avatars.mds.yandex.net/get-serp/39681/412e1ad5-e673-4f6c-8a87-157bc455e4e6/orig',
        car_models.SOLARIS.short_name: 'https://avatars.mds.yandex.net/get-serp/15230/8702feb0-c2ad-4186-ab20-8ae72917b9db/orig',
    },
    operators.CARENDA.short_name: {
        car_models.KIA_RIO.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/479883/carenda_rio/orig',
        car_models.RAVON_R2.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/479883/carenda_ravonr2/orig',
        car_models.SOLARIS.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/880310/carenda_solaris/orig',
    },
    operators.COLESA.short_name: {
        car_models.FIAT_500.short_name: 'https://avatars.mds.yandex.net/get-serp/28672/91bdf7f8-1e88-4d46-b982-6c5cb0353847/orig',
        car_models.FORD_FIESTA.short_name: 'https://avatars.mds.yandex.net/get-serp/39681/5977da57-e601-41bd-9af6-c2ff8ec8db80/orig',
        car_models.KIA_RIO.short_name: 'https://avatars.mds.yandex.net/get-serp/28672/0d655c41-d9c2-4c8f-9b00-cb03a658e9c9/orig',
        car_models.MINI_COOPER.short_name: 'https://avatars.mds.yandex.net/get-serp/34166/78be5974-50aa-4c1e-a7f1-3733373b1e64/orig',
        car_models.SMART_FORTWO.short_name: 'https://avatars.mds.yandex.net/get-serp/34166/78be5974-50aa-4c1e-a7f1-3733373b1e64/orig',
        car_models.SOLARIS.short_name: 'https://avatars.mds.yandex.net/get-serp/15230/582f11bd-47ba-47aa-aedf-cff68193875b/orig',
    },
    operators.DELIMOBIL.short_name: {
        car_models.SOLARIS.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/759349/delimobil_solaris/orig',
        car_models.SOLARIS_NEW.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/759349/delimobil_solaris_new/orig',
        car_models.RENAULT_KAPTUR.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/759349/delimobil_kaptur/orig',
    },
    operators.DRIVETIME.short_name: {
        car_models.RAVON_R2.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/880310/DriveTime-chevrolet/orig',
        car_models.RENAULT_SANDERO.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/880310/DriveTime-reno/orig',
    },
    operators.GREENGO.short_name: {
        car_models.VOLKSWAGEN_E_UP.short_name: {
            CarModel.Color.BLUE.value: 'https://avatars.mds.yandex.net/get-serp/39011/c68b129e-6972-4e85-8e3a-386a5ec7ddd8/orig',
            CarModel.Color.GRAY.value: 'https://avatars.mds.yandex.net/get-serp/34166/829336ad-36af-4ffb-8587-050a3e3b4f2c/orig',
            CarModel.Color.WHITE.value: 'https://avatars.mds.yandex.net/get-serp/28672/30f32474-a7e4-42c9-87ac-dad828771a3b/orig',
            CarModel.Color.YELLOW.value: 'https://avatars.mds.yandex.net/get-serp/28672/6c1c5a86-a59b-436a-bad1-81df0be28c28/orig',
        },
    },
    operators.MATURCAR.short_name: {
        car_models.SMART_FORTWO.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/759349/maturcar_smartfortwo/orig',
        car_models.RAVON_R2.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/880310/maturcar_ravonr2/orig',
    },
    operators.RENTMEE.short_name: {
        car_models.SOLARIS.short_name: 'https://avatars.mds.yandex.net/get-serp/34166/52116425-9f63-44b2-b8c9-7ed7e1d429d8/orig',
    },
    operators.YANDEX_DRIVE.short_name: {
        car_models.KIA_RIO.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/479883/drive_sedan/orig',
        car_models.KIA_RIO_X_LINE.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/479883/drive_xline/orig',
        car_models.RENAULT_KAPTUR.short_name: 'https://avatars.mds.yandex.net/get-mobile-transport/759349/drive_kaptur/orig',
    }
}


def get_car_photo(operator, model, color):  # pylint: disable=unused-argument
    operator_photos = PHOTOS.get(operator, {})

    color_photos = operator_photos.get(model)
    if color_photos is None:
        return None

    if isinstance(color_photos, str):
        photo = color_photos
    else:
        photo = color_photos.get(color)

    return photo
