# pylint: disable=line-too-long
import shapely.wkt

from cars.core.models import City


ANAPA = City(
    id_=7,
    code=1107,
    short_name='anapa',
    location=shapely.wkt.loads('POINT(37.316259 44.894997)'),
    polygon=shapely.wkt.loads('POLYGON((37.034912 45.183549, 37.537536 45.183549, 37.537536 44.769710, 37.034912 44.769710, 37.034912 45.183549))'),
)


BUDAPEST = City(
    id_=4,
    code=10398,
    short_name='budapest',
    location=shapely.wkt.loads('POINT(19.055073 47.499715)'),
    polygon=shapely.wkt.loads('POLYGON((18.734436 47.701242,19.451293 47.701242,19.451293 47.237082,18.734436 47.237082,18.734436 47.701242))'),
)


CMW = City(
    id_=9,
    code=11069,
    short_name='cmw',
    location=shapely.wkt.loads('POINT(42.966817 44.049002)'),
    polygon=shapely.wkt.loads('POLYGON((42.203979 44.568519, 43.802490 44.568519, 43.802490 43.577965, 42.203979 43.577965, 42.203979 44.568519))'),
)


KRASNODAR = City(
    id_=6,
    code=35,
    short_name='krasnodar',
    location=shapely.wkt.loads('POINT(38.975996 45.040216)'),
    polygon=shapely.wkt.loads('POLYGON((38.336791 45.420744, 39.759521 45.420744, 39.759521 44.699043, 38.336791 44.699043, 38.336791 45.420744))'),
)


MINSK = City(
    id_=3,
    code=157,
    short_name='minsk',
    location=shapely.wkt.loads('POINT(27.561831 53.902257)'),
    polygon=shapely.wkt.loads('POLYGON((27.000274 54.104502, 28.043975 54.104502, 28.043975 53.672307, 27.000274 53.672307, 27.000274 54.104502))'),
)


MSK = City(
    id_=1,
    code=1,
    short_name='msk',
    location=shapely.wkt.loads('POINT(37.620393 55.753960)'),
    polygon=shapely.wkt.loads('POLYGON((35.396388 56.655146, 39.505275 56.655146, 39.505275 54.763740, 35.396388 54.763740, 35.396388 56.655146))'),
)


NOVOROSSIYSK = City(
    id_=8,
    code=970,
    short_name='novorossiysk',
    location=shapely.wkt.loads('POINT(37.768678 44.723566)'),
    polygon=shapely.wkt.loads('POLYGON((37.545776 44.879988, 37.952270 44.879988, 37.952270 44.649879, 37.545776 44.649879, 37.545776 44.879988))'),
)


SOCHI = City(
    id_=5,
    code=239,
    short_name='sochi',
    location=shapely.wkt.loads('POINT(39.723062 43.585525)'),
    polygon=shapely.wkt.loads('POLYGON((38.754272 44.305731, 40.759277 44.305731, 40.759277 42.937888, 38.754272 42.937888, 38.754272 44.305731))'),
)


SPB = City(
    id_=2,
    code=2,
    short_name='spb',
    location=shapely.wkt.loads('POINT(30.315868 59.939095)'),
    polygon=shapely.wkt.loads('POLYGON((28.837412 60.498146, 31.726816 60.498146, 31.726816 59.114705, 28.837412 59.114705, 28.837412 60.498146))'),
)


UFA = City(
    id_=10,
    code=172,
    short_name='ufa',
    location=shapely.wkt.loads('POINT(55.958727 54.735147)'),
    polygon=shapely.wkt.loads('POLYGON((55.387573 54.988941, 56.557617 54.988941, 56.557617 54.475124, 55.387573 54.475124, 55.387573 54.988941))'),
)


# id feld sets ordering.
CITY_LIST = [
    ANAPA,
    BUDAPEST,
    CMW,
    KRASNODAR,
    MINSK,
    MSK,
    NOVOROSSIYSK,
    SOCHI,
    SPB,
    UFA,
]
CITIES = {city.code: city for city in CITY_LIST}
