# pylint: disable=line-too-long
from cars.core import parking_areas
from cars.core.models import Operator, OperatorColor, OperatorIcons

from . import car_models, cities
from .currencies import BYN, HUF, RUB

# Operator.id feld sets ordering in the API.

ANYTIME = Operator(
    id_=4,
    short_name='anytime',
    color=OperatorColor(red=0.8142594099, green=0.09029757231, blue=0.05829346925),
    website='https://anytimecar.ru/',
    faq_url='https://anytimecar.ru/how-it-works/',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id633791132',
    android_store_url='market://details?id=ru.anytimecar.app',
    deeplink='anytimecar://cars/{car_id}/',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/39859/6280e71e-c873-45f0-beec-12df6f3fe457/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/39859/715c6505-44ff-4ca1-a375-5984d59a608c/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/39859/715c6505-44ff-4ca1-a375-5984d59a608c/orig',
    ),
)

ANYTIME_MSK = ANYTIME.localize(
    city=cities.MSK,
    currency=RUB,
    phone='+7 (800) 775-26-64',
    car_models=[
        car_models.BMW_116I,
        car_models.KIA_RIO,
        car_models.RENAULT_KANGOO,
        car_models.SKODA_OCTAVIA,
        car_models.SOLARIS,
    ],
    parkings=parking_areas.AnyTimeParkingAreasManager(),
)


BELKA = Operator(
    id_=3,
    short_name='belka',
    color=OperatorColor(red=0.05765916407, green=0.2263329923, blue=0.3501111269),
    website='https://belkacar.ru/',
    faq_url='https://belkacar.ru/faq',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1113709902',
    android_store_url='market://details?id=ru.belkacar.belkacar',
    deeplink='belkacar://car-map?car_id={car_id}',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/39681/412a321d-8a9d-4358-a718-a84f1bb83635/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/39681/1b917fe2-f3cb-4cb7-83a3-c6020483eb69/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/39681/1b917fe2-f3cb-4cb7-83a3-c6020483eb69/orig',
    ),
)

BELKA_MSK = BELKA.localize(
    city=cities.MSK,
    currency=RUB,
    phone='+7 (495) 234-33-00',
    car_models=[
        car_models.FORD_FIESTA,
        car_models.KIA_RIO,
        car_models.MERCEDES_BENZ,
    ],
    parkings=parking_areas.BelkaCarParkingAreasManager(),
)


CAR5 = Operator(
    id_=5,
    short_name='car5',
    color=OperatorColor(red=0.09019607843137255, green=0.7450980392156863, blue=0.9411764705882353),
    website='https://car5.ru/',
    faq_url='https://car5.ru/faq.htm',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1135418958',
    android_store_url='market://details?id=ru.car5',
    deeplink='car5://findCar?car_id={car_id}',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/39681/7710c3aa-bf32-4822-bb9a-cad9ee752ec5/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/39681/5ff3b79c-fdd4-4577-9aa1-13ab0da14882/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/39681/5ff3b79c-fdd4-4577-9aa1-13ab0da14882/orig',
    ),
)

CAR5_MSK = CAR5.localize(
    city=cities.MSK,
    currency=RUB,
    phone='+7 (495) 151-05-50',
    car_models=[
        car_models.DATSUN,
        car_models.NISSAN_ALMERA,
        car_models.RENAULT_SANDERO,
        car_models.SOLARIS,
        car_models.VOLKSWAGEN_POLO,
    ],
    parkings=parking_areas.Car5ParkingAreasManager(),
)


CARENDA = Operator(
    id_=10,
    short_name='carenda',
    color=OperatorColor(red=0.9372549019607843, green=0.4980392156862745, blue=0.10196078431372549),
    website='https://carenda.ru/',
    faq_url='https://carenda.ru/',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1275578164',
    android_store_url='market://details?id=carenda.android.io.carenda',
    deeplink='carenda://{car_id}',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-mobile-transport/479883/carenda-normal/orig',
        map_selected='https://avatars.mds.yandex.net/get-mobile-transport/880310/carenda-large/orig',
        map_zoom='https://avatars.mds.yandex.net/get-mobile-transport/880310/carenda-large/orig',
    ),
)

CARENDA_MSK = CARENDA.localize(
    city=cities.MSK,
    currency=RUB,
    phone='+7 (495) 481-00-00',
    car_models=[
        car_models.KIA_RIO,
        car_models.RAVON_R2,
        car_models.SOLARIS,
    ],
    parkings=parking_areas.BelkaCarParkingAreasManager(),
)


COLESA = Operator(
    id_=9,
    short_name='colesa',
    color=OperatorColor(red=0.0, green=0.5294117647058824, blue=0.803921568627451),
    website='https://colesa.com',
    faq_url='https://colesa.com/faq',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1189944277',
    android_store_url='market://details?id=com.colesa.android',
    deeplink='colesa://cars/{car_id}',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/39681/4e4da3d5-cf01-4022-88e2-085608b9f0a1/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/15230/87a17c38-1997-4193-95d7-caa06a747cd7/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/15230/87a17c38-1997-4193-95d7-caa06a747cd7/orig',
    ),
)

COLESA_SPB = COLESA.localize(
    city=cities.SPB,
    currency=RUB,
    phone='+7 (812) 926-42-60',
    car_models=[
        car_models.FIAT_500,
        car_models.FORD_FIESTA,
        car_models.KIA_RIO,
        car_models.MINI_COOPER,
        car_models.SMART_FORTWO,
        car_models.SOLARIS,
    ],
    parkings=parking_areas.ColesaSpbParkingAreasManager(),
)


DELIMOBIL = Operator(
    id_=1,
    short_name='delimobil',
    color=OperatorColor(red=0.951502502, green=0.4165545106, blue=0.1300644279),
    website='https://delimobil.ru/',
    faq_url='https://delimobil.ru/faq',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1038254296',
    android_store_url='market://details?id=com.carshering',
    deeplink='delimobil://{car_id}',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/39859/eb64c115-fc12-4ced-bc0d-6a189851ff63/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/23508/f5f779e9-d083-4848-8a54-540ce417feeb/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/23508/f5f779e9-d083-4848-8a54-540ce417feeb/orig',
    ),
)

DELIMOBIL_MSK = DELIMOBIL.localize(
    city=cities.MSK,
    currency=RUB,
    phone='+7 (495) 234-22-44',
    car_models=[
        car_models.RENAULT_KAPTUR,
        car_models.SOLARIS,
    ],
    parkings=parking_areas.DelimobilMskParkingAreasManager(),
)

DELIMOBIL_SPB = DELIMOBIL.localize(
    city=cities.SPB,
    currency=RUB,
    phone='+7 (800) 234-22-44',
    car_models=[
        car_models.SOLARIS,
    ],
    parkings=parking_areas.DelimobilSpbParkingAreasManager(),
)

DELIMOBIL_UFA = DELIMOBIL.localize(
    city=cities.UFA,
    currency=RUB,
    phone='+7 (800) 234-22-44',
    car_models=[
        car_models.SOLARIS,
    ],
    parkings=parking_areas.DelimobilSpbParkingAreasManager(),
)


DRIVETIME = Operator(
    id_=6,
    short_name='drivetime',
    color=OperatorColor(red=0.9921568627450981, green=0.7647058823529411, blue=0.08235294117647059),
    website='http://drivetime.by/',
    faq_url='http://drivetime.by/',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1231153647',
    android_store_url='market://details?id=by.drivetime.app',
    deeplink='drivetime://car?id={car_id}&pid=ytransport',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/15207/76523ae4-2d22-45dd-8178-60fea7d5a782/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/39859/f5b11485-be76-465f-9f62-4b40b60bcc76/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/39859/f5b11485-be76-465f-9f62-4b40b60bcc76/orig',
    ),
)

DRIVETIME_MINSK = DRIVETIME.localize(
    city=cities.MINSK,
    currency=BYN,
    phone='+375 (44) 555-74-74',
    car_models=[
        car_models.RAVON_R2,
        car_models.RAVON_R3,
        car_models.RENAULT_SANDERO,
    ],
    parkings=parking_areas.DriveTimeParkingAreasManager(),
)


EASYRIDE = Operator(
    id_=11,
    short_name='easyride',
    color=OperatorColor(red=1, green=1, blue=1),
    website='http://easyride.ru/',
    faq_url='http://easyride.ru/#how-it-works',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1278753944',
    android_store_url='market://details?id=ru.cariot.share.easyRide',
    deeplink='easyride://',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/15207/76523ae4-2d22-45dd-8178-60fea7d5a782/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/39859/f5b11485-be76-465f-9f62-4b40b60bcc76/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/39859/f5b11485-be76-465f-9f62-4b40b60bcc76/orig',
    ),
)

EASYRIDE_MSK = EASYRIDE.localize(
    city=cities.MSK,
    currency=RUB,
    phone='+7 (495) 744-72-13',
    car_models=[
        car_models.RENAULT_KAPTUR,
    ],
    parkings=parking_areas.EasyRideParkingAreasManager(),
)


GREENGO = Operator(
    id_=7,
    short_name='greengo',
    color=OperatorColor(red=0.01, green=0.7686274509803922, blue=0.01),
    website='https://www.greengo.hu/',
    faq_url='https://www.greengo.hu/gyik.html',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1124380615',
    android_store_url='market://details?id=com.GreenGo',
    deeplink='greengo://greengo.hu/?vehicle={car_id}',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/15207/1927b319-c2de-4021-844a-212621f1d2f3/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/34166/1c9f3536-3dd5-42d6-a8aa-428920580d51/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/34166/1c9f3536-3dd5-42d6-a8aa-428920580d51/orig',
    ),
)

GREENGO_BUDAPEST = GREENGO.localize(
    city=cities.BUDAPEST,
    currency=HUF,
    phone='+36 1 885 2015',
    car_models=[
        car_models.VOLKSWAGEN_E_UP,
    ],
    parkings=parking_areas.GreenGoParkingAreasManager(),
)


MATURCAR = Operator(
    id_=12,
    short_name='maturcar',
    color=OperatorColor(red=0.8980392156862745, green=0.09411764705882353, blue=0.09019607843137255),
    website='https://www.maturcar.ru/',
    faq_url='https://www.maturcar.ru/',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1278606960',
    android_store_url='market://details?id=ru.maturcar.app',
    deeplink='maturcar://',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-mobile-transport/479883/maturcar-normal/orig',
        map_selected='https://avatars.mds.yandex.net/get-mobile-transport/880310/maturcar-large/orig',
        map_zoom='https://avatars.mds.yandex.net/get-mobile-transport/880310/maturcar-large/orig',
    ),
)

MATURCAR_UFA = MATURCAR.localize(
    city=cities.UFA,
    currency=RUB,
    phone='+7 (987) 1000-308',
    car_models=[
        car_models.RAVON_R2,
        car_models.SMART_FORTWO,
    ],
    parkings=parking_areas.MaturCarUfaParkingAreasManager(),
)


RENTMEE = Operator(
    id_=8,
    short_name='rentmee',
    color=OperatorColor(red=0.01, green=0.7843137254901961, blue=0.3254901960784314),
    website='https://rentmee.club/',
    faq_url='https://rentmee.club/index.cfm?q=ru/rossia/moskva/voprosi/',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1142193212',
    android_store_url='market://details?id=club.rentmee.apps',
    deeplink='rentmee://cars?id={car_id}',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/39681/710cb7d9-67d9-4ee8-9c58-6aae352e3927/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/34166/23c0e1cf-8823-4671-bafb-387d18989a55/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/34166/23c0e1cf-8823-4671-bafb-387d18989a55/orig',
    ),
)

RENTMEE_MSK = RENTMEE.localize(
    city=cities.MSK,
    currency=RUB,
    phone='+7 (804) 333-75-25',
    car_models=[
        car_models.SOLARIS,
    ],
    parkings=parking_areas.RentmeeMskParkingAreasManager(),
)

RENTMEE_SPB = RENTMEE.localize(
    city=cities.SPB,
    currency=RUB,
    phone='+7 (804) 333-75-25',
    car_models=[
        car_models.SOLARIS,
    ],
    parkings=parking_areas.RentmeeSpbParkingAreasManager(),
)


URENTCAR = Operator(
    id_=9,
    short_name='urentcar',
    color=OperatorColor(red=0.30196078431372547, green=0.7215686274509804, blue=0.09411764705882353),
    website='https://carsharing.urentcar.ru/',
    faq_url='https://carsharing.urentcar.ru/regulations.html',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1176404930',
    android_store_url='market://details?id=online.cartrek.urentcar',
    deeplink='urentcar://car?id={car_id}&pid=yandex&c=carsharings&clickid=0',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/15207/76523ae4-2d22-45dd-8178-60fea7d5a782/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/39859/f5b11485-be76-465f-9f62-4b40b60bcc76/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/39859/f5b11485-be76-465f-9f62-4b40b60bcc76/orig',
    ),
)
URENTCAR_MODELS = [
    car_models.CHEVROLET_AVEO,
    car_models.CHEVROLET_SPARK,
    car_models.DATSUN,
    car_models.FORD_FOCUS,
    car_models.KIA_RIO,
    car_models.NISSAN_ALMERA,
    car_models.OPEL_ASTRA,
    car_models.RAVON_R2,
    car_models.RENAULT_LOGAN,
    car_models.SKODA_FABIA,
    car_models.SKODA_RAPID,
    car_models.SOLARIS,
    car_models.VOLKSWAGEN_POLO,
    car_models.DEFAULT_MODEL,
]

URENTCAR_ANAPA = URENTCAR.localize(
    city=cities.ANAPA,
    currency=RUB,
    phone='8 (800) 700-95-74',
    car_models=URENTCAR_MODELS,
    parkings=parking_areas.URentCarAnapaParkingAreasManager(),
)

URENTCAR_CMW = URENTCAR.localize(
    city=cities.CMW,
    currency=RUB,
    phone='8 (800) 700-95-74',
    car_models=URENTCAR_MODELS,
    parkings=parking_areas.URentCarCmwParkingAreasManager(),
)

URENTCAR_KRASNODAR = URENTCAR.localize(
    city=cities.KRASNODAR,
    currency=RUB,
    phone='8 (800) 700-95-74',
    car_models=URENTCAR_MODELS,
    parkings=parking_areas.URentCarKrasnodarParkingAreasManager(),
)

URENTCAR_NOVOROSSIYSK = URENTCAR.localize(
    city=cities.NOVOROSSIYSK,
    currency=RUB,
    phone='8 (800) 700-95-74',
    car_models=URENTCAR_MODELS,
    parkings=parking_areas.URentCarNovorossiyskParkingAreasManager(),
)

URENTCAR_SOCHI = URENTCAR.localize(
    city=cities.SOCHI,
    currency=RUB,
    phone='8 (800) 700-95-74',
    car_models=URENTCAR_MODELS,
    parkings=parking_areas.URentCarSochiParkingAreasManager(),
)


YANDEX_DRIVE = Operator(
    id_=13,
    short_name='yandex_drive',
    color=OperatorColor(red=0.1411764705882353, green=0.1411764705882353, blue=0.9764705882352941),
    website='https://yandex.ru/drive/',
    faq_url='https://yandex.ru/support/drive',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id1318875022',
    android_store_url='market://details?id=com.yandex.mobile.drive',
    deeplink='yandexdrive://cars/{car_id}',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-mobile-transport/479883/drive_logo/orig',
        map_selected='https://avatars.mds.yandex.net/get-mobile-transport/479883/drive_logo/orig',
        map_zoom='https://avatars.mds.yandex.net/get-mobile-transport/479883/drive_logo/orig',
    )
)


YANDEX_DRIVE_MSK = YANDEX_DRIVE.localize(
    city=cities.MSK,
    currency=RUB,
    phone='+7 495 410-68-22',
    car_models=[
        car_models.KIA_RIO,
        car_models.KIA_RIO_X_LINE,
        car_models.RENAULT_KAPTUR,
    ],
    parkings=parking_areas.YandexDriveMskParkingAreasManager(),
)


YOUDRIVE = Operator(
    id_=2,
    short_name='youdrive',
    color=OperatorColor(red=0.07350385934, green=0.7157369852, blue=0.3927892148),
    website='https://youdrive.today/',
    faq_url='https://youdrive.today/tariffs-regulations.html',
    ios_store_url='itms-apps://itunes.apple.com/ru/app/id989836024',
    android_store_url='market://details?id=youdrive.today',
    deeplink='fb446698825691645://',
    icons=OperatorIcons(
        map_default='https://avatars.mds.yandex.net/get-serp/34166/c06b73a7-3b9c-48c1-bb72-32f7a6f0f441/orig',
        map_selected='https://avatars.mds.yandex.net/get-serp/39859/bebf14b1-c362-43bd-adc9-c6283bc9b892/orig',
        map_zoom='https://avatars.mds.yandex.net/get-serp/39859/bebf14b1-c362-43bd-adc9-c6283bc9b892/orig',
    ),
)

YOUDRIVE_MSK = YOUDRIVE.localize(
    city=cities.MSK,
    currency=RUB,
    phone='+7 (499) 322-38-75',
    car_models=[
        car_models.SKODA_RAPID,
        car_models.SMART_FORFOUR,
        car_models.SMART_FORTWO,
    ],
    parkings=parking_areas.YouDriveMskParkingAreasManager(),
)

YOUDRIVE_SPB = YOUDRIVE.localize(
    city=cities.SPB,
    currency=RUB,
    phone='+7 (812) 407-10-69',
    car_models=[
        car_models.KIA_RIO,
        car_models.SKODA_RAPID,
        car_models.SMART_FORTWO,
    ],
    parkings=parking_areas.YouDriveSpbParkingAreasManager(),
)


OPERATOR_LIST = [
    ANYTIME,
    BELKA,
    CAR5,
    CARENDA,
    COLESA,
    DELIMOBIL,
    DRIVETIME,
    EASYRIDE,
    GREENGO,
    MATURCAR,
    RENTMEE,
    URENTCAR,
    YANDEX_DRIVE,
]
LOCAL_OPERATOR_LIST = [
    ANYTIME_MSK,
    BELKA_MSK,
    CAR5_MSK,
    CARENDA_MSK,
    COLESA_SPB,
    DELIMOBIL_MSK, DELIMOBIL_SPB, DELIMOBIL_UFA,
    DRIVETIME_MINSK,
    EASYRIDE_MSK,
    GREENGO_BUDAPEST,
    MATURCAR_UFA,
    RENTMEE_MSK, RENTMEE_SPB,
    YANDEX_DRIVE_MSK,
    URENTCAR_ANAPA, URENTCAR_CMW, URENTCAR_KRASNODAR, URENTCAR_NOVOROSSIYSK, URENTCAR_SOCHI,
]

OPERATORS = {operator.short_name: operator for operator in OPERATOR_LIST}

LOCAL_OPERATORS = {}
for local_operator in LOCAL_OPERATOR_LIST:
    city_code = local_operator.city.code
    local_operators_per_city = LOCAL_OPERATORS.setdefault(city_code, {})
    local_operators_per_city[local_operator.short_name] = local_operator
