from django.conf.urls import include, url

from . import views


app_name = 'aggregator'


taxi_urlpatterns = (
    [
        url(r'^send_code/$', views.taxi.SendCodeView.as_view(), name='send_code'),
        url(r'^orders/$', views.taxi.OrdersView.as_view(), name='orders'),
    ],
    'aggregator-taxi',
)


urlpatterns = [
    url(
        r'^cars/(?P<car_id>[\w-]+)/$',
        views.GoneView.as_view(),  # views.CarDetailsView.as_view(),
        name='cars_car'
    ),
    url(
        r'^cars/free/$',
        views.GoneView.as_view(),  # views.FreeCarsView.as_view(),
        name='cars_free'
    ),
    url(
        r'^operators/$',
        views.GoneView.as_view(),  # views.OperatorsList.as_view(),
        name='operators'
    ),
    url(
        r'^models/$',
        views.GoneView.as_view(),  # views.CarModelList.as_view(),
        name='models'
    ),

    url(r'^alerts/cancel/$', views.AlertCancellationView.as_view(), name='alerts_cancel'),
    url(r'^alerts/subscribe/$', views.AlertSubscriptionView.as_view(), name='alerts_subscribe'),
    url(r'^cars/delta/$', views.ModifiedCarsView.as_view(), name='cars_delta'),
    url(r'^cars/nearest/$', views.NearestCarsView.as_view(), name='cars_nearest'),
    url(r'^user/clientid/$', views.ClientIdView.as_view(), name='user_clientid'),
    url(r'^cities/$', views.CitiesView.as_view(), name='cities'),
    url(r'^landmarks/$', views.LandmarksView.as_view(), name='landmarks'),
    url(r'^landing/$', views.LandingView.as_view(), name='landing'),
    url(r'^landing/sms/$', views.LandingSmsView.as_view(), name='landing_sms'),
    url(r'^push/$', views.PushView.as_view(), name='push'),
    url(r'^taxi/', include(taxi_urlpatterns, namespace='taxi')),
    url(r'^walk_areas/$', views.WalkAreasView.as_view(), name='walk_areas'),
]
