from rest_framework import status
from rest_framework.response import Response

from cars.taxi import TaxiApi
from ..serializers.taxi import TaxiMakeOrderParametersSerializer, TaxiSendCodeParametersSerializer
from .common import ParametrizedAPIView


API = TaxiApi()


class SendCodeView(ParametrizedAPIView):

    parameters_serializer_class = TaxiSendCodeParametersSerializer

    def post(self, request):
        params = self.get_parameters(request.data)
        API.send_validation_code(
            platform=params['platform'],
            device_id=params['device_id'],
        )
        return Response()


class OrdersView(ParametrizedAPIView):

    parameters_serializer_class = TaxiMakeOrderParametersSerializer

    def post(self, request):
        params = self.get_parameters(request.data)
        is_code_valid = API.validate_code(
            device_id=params['device_id'],
            code=params['code'],
        )
        if not is_code_valid:
            return Response(status=status.HTTP_403_FORBIDDEN)


        src_point = params['source']['coordinates']
        dst_point = params['destination']['coordinates']
        order_id = API.make_order(
            platform=params['platform'],
            device_id=params['device_id'],
            src_point=src_point,
            dst_point=dst_point,
        )

        return Response({
            'order_id': order_id,
        })
