from rest_framework import status
from rest_framework.response import Response
from rest_framework.views import APIView

from cars.core.pedestrian_router import PedestrianRouter

from ..filters import WalkAreasFilter


class WalkAreasView(APIView):

    filter_backends = [WalkAreasFilter]

    _prouter = PedestrianRouter()

    def get(self, request, _=None):
        '''
        Areas reachable by feet

        Return a list of walkable areas sorted by distance from the initial point.
        '''

        try:
            min_walk_time = float(request.query_params['min_walk_time'])
            max_walk_time = float(request.query_params['max_walk_time'])
            num_areas = int(request.query_params['num_areas'])
            point = [float(coord) for coord in request.query_params['ll'].split(',')]
            assert len(point) == 2
        except Exception:
            return Response(status=status.HTTP_400_BAD_REQUEST)

        response = self._prouter.build_many_areas_from_time(
            point=point,
            min_walk_seconds=min_walk_time,
            max_walk_seconds=max_walk_time,
            num_areas=num_areas,
        )

        return Response(response)
